#include "max.h"
#include "rwcore.h"
#include "rpworld.h"
#include "rpskin.h"
#include <vector>
using namespace std;
#include "remapper.h"

struct BoneNumberWeight
{
    int BoneNumber;
    RwReal Weight;
};

typedef vector<INode *> INODEVECTOR;
typedef vector<float> FLOATVECTOR;
typedef vector<int> INTVECTOR;
//typedef vector<BoneNumberWeight *> BONENUMBERWEIGHTVECTOR;

//abstract class
class SkinExport
{
protected:
    INode *SkinNode;
    Modifier *SkinModifier;
    int NumBones;
    INODEVECTOR BoneNodeList; //list of nodes associated with bones
    FLOATVECTOR WeightList;
    INTVECTOR VertexList;
    INTVECTOR BoneNumberList;
    virtual void MakeBoneNodeList(void)=0; //abstract
    virtual void MakeVertexBoneWeightMap(void)=0; //abstract
private:
    //INODEVECTOR *INodeList;
    void ProcessSkinNodesInHierarchy(INode *node, RpClump *clump);
    void ProcessSkinNode(INode *node, RpClump *clump);
    //INode *FindNode(INode *root);
    void CalculateSkinVertexBoneMap(void);
    void MakeTransform(void);
public:
    //INode *SkinNode;
    ReMapper *remapper;
    RwInt32 *VertexMap;
    RwUInt32 *SkinVertexIndices; //output
    RwMatrixWeights *SkinMatrixWeights; //output
    RwUInt32 *SkinFlags;
    RwMatrix *SkinInverseMatrices;
    SkinExport();
    ~SkinExport();
    void Export(RpClump *clump, RpAtomic *Atomic);
};